<?php
define('MENARDS_CID',	30);
define('HOMEDEPOT_CID', 22);
define('LOWES_CID',		17);
define('FLEETFARM_CID',	126);
define('BLAINS_CID',	127);
define('SUTHERLANDS_CID',	150);

define('MAX_CYCLES_IN_TABLE', 4);

define('MAP_CRAWLER', [
	MENARDS_CID		=> 'Menards',
	HOMEDEPOT_CID	=> 'Homedepot',
	LOWES_CID		=> 'Lowes',
	FLEETFARM_CID	=> 'Fleetfarm',
	BLAINS_CID		=> 'Farmandfleet',
	SUTHERLANDS_CID	=> 'Sutherlands',
]);
$crawler_rev = array_flip(MAP_CRAWLER);

define('MAP_CRAWLER_REV', $crawler_rev);

$running = shell_exec('ps aux|grep "_zip_url.php 384"');
$tasks = explode("\n", $running);

$running_multi = shell_exec('ps aux|grep "zip_url_multi.php 384"');
$tasks_multi = explode("\n", $running_multi);

require_once "/home/mysamm/ibmspace/price_checker/lib/connection.php"; 
$db = new Connection();

// $max_created_m = $db->Query("SELECT crawler_id, MAX(created) AS created from rheem_menards_raw_price_analyser_mysamm_8 group by crawler_id");

$max_created_m = $db->Query("SELECT p1.id, p2.crawler_id, p2.created, COUNT(*) as counting FROM rheem_menards_raw_price_analyser_mysamm_8 p1 JOIN (select crawler_id, max(created) as created from rheem_menards_raw_price_analyser_mysamm_8 group by crawler_id) p2 on p1.crawler_id = p2.crawler_id and p1.created = p2.created GROUP BY p2.crawler_id, p2.created;");


$crawling_info = [];
foreach($max_created_m as $info)
{
	$crawler_id = $info['crawler_id'];
	$created = $info['created'];
	$counting = $info['counting'];
	$crawling_info['menards'][strtolower(MAP_CRAWLER[$crawler_id])] = [
		'crawler_id'		=> $crawler_id,
		'crawler_name'		=> strtolower(MAP_CRAWLER[$crawler_id]),
		'crawl_date'		=> $created,
		'counting'			=> $counting,
		'running_status'	=> 'Not Running',
		'instances'			=> 'Single',
	];
}


$max_created_h = $db->Query("SELECT p1.id, p2.crawler_id, p2.created, COUNT(*) as counting FROM rheem_homedepot_raw_price_analyser_mysamm_8 p1 JOIN (select crawler_id, max(created) as created from rheem_homedepot_raw_price_analyser_mysamm_8 group by crawler_id) p2 on p1.crawler_id = p2.crawler_id and p1.created = p2.created GROUP BY p2.crawler_id, p2.created;");

foreach($max_created_h as $info)
{
	$crawler_id = $info['crawler_id'];
	$created = $info['created'];
	$counting = $info['counting'];
	$crawling_info['homedepot'][strtolower(MAP_CRAWLER[$crawler_id])] = [
		'crawler_id'		=> $crawler_id,
		'crawler_name'		=> strtolower(MAP_CRAWLER[$crawler_id]),
		'crawl_date'		=> $created,
		'counting'			=> $counting,
		'running_status'	=> 'Not Running',
		'instances'			=> 'Single',
	];
}

foreach($tasks as $task)
{
	if(mb_substr($task, 0, 6) == 'mysamm')
	{
		$task = preg_replace('!\s+!', ' ', $task);
		$taskss = explode(" ", trim($task));
		echo '<pre>';
		print_r($crawling_info);
		echo '</pre>';
		$script_file = $taskss[11];
		$website = explode("_", $script_file)[0];
		
		$centric = $taskss[13];
		$crawler_id = $crawling_info[$centric][$website]['crawler_id'];
		$crawl_date = $crawling_info[$centric][$website]['crawl_date'];

		$crawling_info[$centric][$website]['running_status'] = 'Running';
		
	}
}

$multi_threads_running = [];
foreach($tasks_multi as $task)
{
	if(mb_substr($task, 0, 6) == 'mysamm')
	{
		$task = preg_replace('!\s+!', ' ', $task);
		$taskss = explode(" ", trim($task));
		$script_file = $taskss[12];
		$website = explode("_", end(explode("/", $script_file)))[0];
		$centric = $taskss[14];
		$crawler_id = $crawling_info[$centric][$website]['crawler_id'];
		$crawl_date = $crawling_info[$centric][$website]['crawl_date'];

		$multi_threads_running[$centric][$website][] = [
			'website'	=> $website, 
			'crawl_date'	=> $crawl_date
		];
	}
}

foreach($multi_threads_running as $centric => $multi_threads)
{
	foreach($multi_threads as $website => $running_instances)
	{
		$crawler_id = $crawling_info[$centric][$website]['crawler_id'];
		$crawl_date = $crawling_info[$centric][$website]['crawl_date'];
		$crawling_info[$centric][$website]['running_status'] = 'Running';
		$crawling_info[$centric][$website]['instances'] = count($running_instances);
	}
	
}

$crawling_info['menards']['menards']['total_products']		= 693;
$crawling_info['menards']['lowes']['total_products']		= 12237;
$crawling_info['menards']['homedepot']['total_products']	= 627;
$crawling_info['menards']['fleetfarm']['total_products'] 	= 462;
$crawling_info['menards']['farmandfleet']['total_products']	= 330;
$crawling_info['menards']['sutherlands']['total_products']	= 231;

$crawling_info['homedepot']['menards']['total_products']	= 81732;
$crawling_info['homedepot']['homedepot']['total_products']	= 208222;
$crawling_info['homedepot']['lowes']['total_products']		= 147896;
?>
<div class="table-responsive">
	<table class="table table-striped text-nowrap mb-0">
		<thead class="bg-theme1 text-white">
			<tr>
				<th>Crawler Id</th>
				<th>Website</th>
				<th>Centric</th>
				<th>Running Instances</th>
				<th>Totsl Products</th>
				<th>Product Crawled</th>
				<th>Crawling Date</th>
				<th>Status</th>
			</tr>
		</thead>
		<tbody>
			<?php
			foreach($crawling_info as $centric => $crawlings)
			{
				foreach($crawlings as $crawl)
				{
					$running_status = $crawl['running_status'];
					if($crawl['total_products'] == $crawl['counting'])
					{
						$running_status = 'Completed';
					}
					else if($crawl['total_products'] != $crawl['counting'] && $crawl['running_status'] == 'Not Running')
					{
						$running_status = 'Stopped';
					}
					
					echo '
					<tr>
						<td>'.$crawl['crawler_id'].'</td>
						<td>'.ucwords($crawl['crawler_name']).'</td>
						<td>'.ucwords($centric).'</td>
						<td>'.$crawl['instances'].'</td>
						<td>'.$crawl['total_products'].'</td>
						<td>'.$crawl['counting'].'</td>
						<td>'.$crawl['crawl_date'].'</td>
						<td>'.$running_status.'</td>
					</tr>			
					';
				}
			}
			
			?>
		</tbody>
	</table>
</div>