<?php
define('MENARDS_CID',	30);
define('HOMEDEPOT_CID', 22);
define('LOWES_CID',		17);
define('FLEETFARM_CID',	126);
define('BLAINS_CID',	127);
define('SUTHERLANDS_CID',	150);

define('MAX_CYCLES_IN_TABLE', 4);

define('MAP_CRAWLER', [
	MENARDS_CID		=> 'Menards',
	HOMEDEPOT_CID	=> 'Homedepot',
	LOWES_CID		=> 'Lowes',
	FLEETFARM_CID	=> 'Fleetfarm',
	BLAINS_CID		=> 'Farmandfleet',
	SUTHERLANDS_CID	=> 'Sutherlands',
]);
$crawler_rev = array_flip(MAP_CRAWLER);

define('MAP_CRAWLER_REV', $crawler_rev);

require_once "/home/mysamm/ibmspace/price_checker/lib/connection.php"; 
$db = new Connection();

$max_created_m = $db->Query("SELECT p1.id, p2.crawler_id, p2.created, COUNT(*) as counting FROM rheem_menards_raw_price_analyser_mysamm_8 p1 JOIN (select crawler_id, max(created) as created from rheem_menards_raw_price_analyser_mysamm_8 group by crawler_id) p2 on p1.crawler_id = p2.crawler_id and p1.created = p2.created GROUP BY p2.crawler_id, p2.created;");

$crawling_info = [];
foreach($max_created_m as $info)
{
	$crawler_id = $info['crawler_id'];
	$created = $info['created'];
	$counting = $info['counting'];
	$crawling_info['menards'][strtolower(MAP_CRAWLER[$crawler_id])] = [
		'crawler_id'		=> $crawler_id,
		'crawler_name'		=> strtolower(MAP_CRAWLER[$crawler_id]),
		'crawl_date'		=> $created,
		'counting'			=> $counting,
		'running_status'	=> 'Not Running',
		'instances'			=> 'Single',
	];
}

$max_created_h = $db->Query("SELECT p1.id, p2.crawler_id, p2.created, COUNT(*) as counting FROM rheem_homedepot_raw_price_analyser_mysamm_8 p1 JOIN (select crawler_id, max(created) as created from rheem_homedepot_raw_price_analyser_mysamm_8 group by crawler_id) p2 on p1.crawler_id = p2.crawler_id and p1.created = p2.created GROUP BY p2.crawler_id, p2.created;");

foreach($max_created_h as $info)
{
	$crawler_id = $info['crawler_id'];
	$created = $info['created'];
	$counting = $info['counting'];
	$crawling_info['homedepot'][strtolower(MAP_CRAWLER[$crawler_id])] = [
		'crawler_id'		=> $crawler_id,
		'crawler_name'		=> strtolower(MAP_CRAWLER[$crawler_id]),
		'crawl_date'		=> $created,
		'counting'			=> $counting,
		'running_status'	=> 'Not Running',
		'instances'			=> 'Single',
	];
}


$running = shell_exec('ps aux|grep "_zip_url.php"');
$tasks = explode("\n", $running);

foreach($tasks as $task)
{
	if(mb_substr($task, 0, 6) == 'mysamm')
	{
		$task = preg_replace('!\s+!', ' ', $task);
		$taskss = explode(" ", trim($task));
		$script_file = $taskss[11];
		$website = explode("_", $script_file)[0];
		
		$centric = $taskss[13];
		$crawler_id = $crawling_info[$centric][$website]['crawler_id'];
		$crawl_date = $crawling_info[$centric][$website]['crawl_date'];

		$crawling_info[$centric][$website]['running_status'] = 'Running';
		
	}
}

$running_multi = shell_exec('ps aux|grep "zip_url_multi.php 384"');
$tasks_multi = explode("\n", $running_multi);

$multi_threads_running = [];
foreach($tasks_multi as $task)
{
	if(mb_substr($task, 0, 6) == 'mysamm')
	{
		$task = preg_replace('!\s+!', ' ', $task);
		$taskss = explode(" ", trim($task));
		$script_file = $taskss[12];
		$website = explode("_", end(explode("/", $script_file)))[0];
		$centric = $taskss[14];
		$crawler_id = $crawling_info[$centric][$website]['crawler_id'];
		$crawl_date = $crawling_info[$centric][$website]['crawl_date'];

		$multi_threads_running[$centric][$website][] = [
			'website'	=> $website, 
			'crawl_date'	=> $crawl_date
		];
	}
}

foreach($multi_threads_running as $centric => $multi_threads)
{
	foreach($multi_threads as $website => $running_instances)
	{
		$crawler_id = $crawling_info[$centric][$website]['crawler_id'];
		$crawl_date = $crawling_info[$centric][$website]['crawl_date'];
		$crawling_info[$centric][$website]['running_status'] = 'Running';
		$crawling_info[$centric][$website]['instances'] = count($running_instances);
	}	
}

$crawling_info['menards']['menards']['total_products']		= 693;
$crawling_info['menards']['lowes']['total_products']		= 12237;
$crawling_info['menards']['homedepot']['total_products']	= 660;
$crawling_info['menards']['fleetfarm']['total_products'] 	= 462;
$crawling_info['menards']['farmandfleet']['total_products']	= 330;
$crawling_info['menards']['sutherlands']['total_products']	= 231;

$crawling_info['homedepot']['menards']['total_products']	= 16985;
$crawling_info['homedepot']['homedepot']['total_products']	= 208222;
$crawling_info['homedepot']['lowes']['total_products']		= 147896;

?>
<div class="table-responsive">
	<table class="table text-nowrap mb-0">
		<thead class="bg-theme1 text-white mb-0">
			<tr>
				<th class="text-center">Crawler Id</th>
				<th class="text-left">Website</th>
				<th class="text-center">Centric</th>
				<th class="text-center">Running Instances</th>
				<th class="text-center">Total Products</th>
				<th class="text-center">Total Crawled</th>
				<th class="text-center">Percentage</th>
				<th class="text-center">Crawl Date</th>
				<th class="text-center">Status</th>
			</tr>
		</thead>
		<tbody>
			<?php
			foreach($crawling_info as $centric => $crawlings)
			{
				foreach($crawlings as $crawl)
				{
					$running_status = $crawl['running_status'];
					if($crawl['total_products'] == $crawl['counting'])
					{
						$running_status = 'Completed';
					}
					else if($crawl['total_products'] != $crawl['counting'] && $crawl['running_status'] == 'Not Running')
					{
						$running_status = 'Stopped';
					}
					
					$tr_class = $td_class = $action = "";
					if($running_status == 'Stopped')
					{
						$tr_class = "alert-danger fw-bold";
						$td_class = "bg-danger fw-bold text-white";
						$slack_message =  ucwords($centric). " centric ".ucwords($crawl['crawler_name'])." crwaling process is stopped";
						// send_slack_notification($slack_message);
						$action = 'Re-Start';
					}
					else if($running_status == 'Running')
					{
						$tr_class = "alert-primary fw-bold";
						$td_class = "bg-primary fw-bold text-white";
					}
					else if($running_status == 'Completed')
					{
						$td_class = "bg-success fw-bold text-white";
					}
					
					echo '
					<tr class="'.$tr_class.'">
						<td class="text-center">'.$crawl['crawler_id'].'</td>
						<td class="text-left">'.ucwords($crawl['crawler_name']).'</td>
						<td class="text-center">'.ucwords($centric).'</td>
						<td class="text-center">'.$crawl['instances'].'</td>
						<td class="text-center">'.$crawl['total_products'].'</td>
						<td class="text-center">'.$crawl['counting'].'</td>
						<td class="text-center">'.get_percentage($crawl['counting'], $crawl['total_products']).'</td>
						<td class="text-center">'.$crawl['crawl_date'].'</td>
						<td class="text-center '.$td_class.'">'.$running_status.'</td>
					</tr>			
					';
				}
			}
			
			?>
		</tbody>
	</table>
</div>

<?php
function get_percentage($number, $out_of)
{
	return number_format(($number * 100)/$out_of, 2)." %";
}

function send_slack_notification($message)
{
	$curl = 'curl -d "text='.$message.'" -d "channel=C02BS8B8JJV" -H "Authorization: Bearer xoxb-17847587268-2976247977380-d1nwZHbzIyJLtGIOs1Ujgjpf" -X POST https://slack.com/api/chat.postMessage';
	shell_exec($curl);
}
?>
