<?php
require '../helpers/helper.php';
require_once "/home/mysamm/ibmspace/price_checker/lib/connection.php"; 
$db = new Connection();
$menards_centric_products = $db->Query("SELECT * FROM menards_product_analyser_input_urls");

$final_array = $product_skus = [];

foreach($menards_centric_products as $products)
{
	$primary_sku	= $products['primary_website_sku'];
	$crawler_id		= $products['crawler_id'];
	$website_sku	= $products['website_sku'];
	
	$final_array[$primary_sku][$crawler_id]['website_sku'] = $website_sku;
	$final_array[$primary_sku][$crawler_id]['website_data'] = $products;
	$product_skus[$crawler_id][] = $website_sku;
}

?>


<div class="table-responsive h-100">
	<table class="table text-nowrap text-center mb-0">
		<thead>
			<tr>
				<th>Total Count</th>
				<th><?= count($product_skus[30]) ?></th>
				<th><?= count($product_skus[30]) ?></th>
				<th><?= count($product_skus[22]) ?></th>
				<th><?= count($product_skus[17]) ?></th>
				<th><?= count($product_skus[127]) ?></th>
				<th><?= count($product_skus[126]) ?></th>
				<th><?= count($product_skus[150]) ?></th>
			</tr>
		</thead>
		<thead class="bg-theme text-white">
			<tr>
				<th>Sr</th>
				<th>Primary SKU</th>
				<th>Menards SKU</th>
				<th>Homedepot SKU</th>
				<th>Lowes SKU</th>
				<th>Fleetfarm SKU</th>
				<th>Farmandfleet SKU</th>
				<th>Sutherlands SKU</th>
			</tr>
		</thead>
		
		<tbody>
            <?php
			$a = 1;
			foreach($final_array as $primary_sku => $mapping)
			{
				echo '
				<tr>
					<td>'.$a++.'</td>
					<td>'.$primary_sku.'</td>
					<td>'.get_mapped_sku($primary_sku, 30).'</td>
					<td>'.get_mapped_sku($primary_sku, 22).'</td>
					<td>'.get_mapped_sku($primary_sku, 17).'</td>
					<td>'.get_mapped_sku($primary_sku, 127).'</td>
					<td>'.get_mapped_sku($primary_sku, 126).'</td>
					<td>'.get_mapped_sku($primary_sku, 150).'</td>
				</tr>
				';
			}
			?>
		</tbody>
	</table>
</div>


<?php
function get_mapped_sku($primary_sku, $crawler_id)
{
	global $final_array;
	if($final_array[$primary_sku][$crawler_id]['website_sku'] != '')
	{
		return '<span class="">'.$final_array[$primary_sku][$crawler_id]['website_sku'].'<span>';
	}
	return '';
}
?>