<?php
$maxlifetime = 36000; 
ini_set('session.gc_maxlifetime', $maxlifetime);
session_start(); 
$root = '/rheem-admin/';
date_default_timezone_set('Asia/Kolkata');
require_once "/home/mysamm/ibmspace/price_checker/lib/connection.php"; 
$db = new Connection();

// border-bottom: solid 3px;
?>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
        <meta name="description" content="" />
        <meta name="author" content="" />
        <title><?= $title ?? 'Rheem Admin Panel - MySamm' ?></title>
        <!-- Favicon-->
        <link rel="icon" type="image/x-icon" href="<?= $root ?>assets/favicon.png" />
        <!-- Core theme CSS (includes Bootstrap)-->
        <link href="<?= $root ?>css/styles.css" rel="stylesheet" />
        <link href="<?= $root ?>css/admin.css" rel="stylesheet" />
		
	</head>
	<?php
	if(isset($_SESSION['is_login']) && $_SESSION['is_login'] == true)
	{
		$current_script_file = $_SERVER['PHP_SELF'];
		$script_explode = explode("/", $current_script_file);
		array_pop($script_explode);
		$current_page = implode("/", $script_explode)."/";

	?>
	<script>
	function updateTime(){
		var str = "";
		var months = new Array("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
		var now = new Date();

		str += now.getDate() + " " + months[now.getMonth()] + " " + now.getFullYear() + " " + now.getHours() +":" + ('0'+now.getMinutes()).slice(-2) + ":" + ('0'+now.getSeconds()).slice(-2);
		document.getElementById("time_span").innerHTML = str;
	}
	setInterval(updateTime, 1000);
	</script>
	<body style="background-color:#e0e5e9;">
		<section class="navbar navbar-expand-lg  bg-theme text-white p-1">
			<div class="row w-100">
				<div class="col-7 text-start px-4">
					Mysamm Super Admin | <a class="link text-white text-decoration-none bg-theme2 p-1 px-2" href="<?= $root ?>logout.php">Logout</a>
				</div>
				<div class="col-5 text-end px-2">
					Server Time: <span id="time_span"></span>
				</div>
			</div>
		</section>
		
		<nav class="navbar navbar-expand-lg navbar-light bg-light border border-bottom-secondary p-0">
			<div class="container-fluid">
				<button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNavDropdown" aria-controls="navbarNavDropdown" aria-expanded="false" aria-label="Toggle navigation">
					<span class="navbar-toggler-icon"></span>
				</button>
				<div class="collapse navbar-collapse" id="navbarNavDropdown">
					<ul class="navbar-nav">
						<li class="nav-item">
							<a class="nav-link active" aria-current="page" href="<?= $root ?>panel/" <?php if($current_page == $root.'panel/') { echo 'style="border-bottom: solid 3px; background: #e2f3ff; font-weight: bold;}"'; } ?>>Panel</a>
						</li>
						<li class="nav-item">
							<a class="nav-link active" href="<?= $root ?>menards-centric-products/" <?php if($current_page == $root.'menards-centric-products/') { echo 'style="border-bottom: solid 3px; background: #e2f3ff; font-weight: bold;"'; } ?>>Menards Centric Products</a>
						</li>
						<li class="nav-item">
							<a class="nav-link active" href="<?= $root ?>homedepot-centric-products/" <?php if($current_page == $root.'homedepot-centric-products/') { echo 'style="border-bottom: solid 3px; background: #e2f3ff; font-weight: bold;"'; } ?>>Homedepot Centric Products</a>
						</li>
						<li class="nav-item">
							<a class="nav-link active" href="<?= $root ?>homedepot-mapped-double-lowes/" <?php if($current_page == $root.'homedepot-mapped-double-lowes/') { echo 'style="border-bottom: solid 3px; background: #e2f3ff; font-weight: bold;"'; } ?>>Mismatch SKUs</a>
						</li>
						<li class="nav-item">
							<form action="https://www.mschannellogin.com/users/login/" method="Post" target="top">
								<input name="data[User][username]" type="hidden" value="Rheem">
								<input name="data[User][password]" type="hidden" value="Captain98!">
								<input type="submit" class="link btn-sm border border-white px-2 mt-1 btn-secondary" value="Login to UI"> 
							</form>
						</li>
						
					</ul>
				</div>
			</div>
		</nav>
		<?php
		if(in_array($_SERVER['PHP_SELF'], [$root.'login.php', $root.'index.php']))
		{
			header('location: '.$root.'panel/');
		}
	}
	else
	{
		?>
		<body class="login-body">
		<?php
		if(!in_array($_SERVER['PHP_SELF'], [$root.'login.php', $root.'index.php']))
		{
			header('location: '.$root);
		}
	}
	?>
