<?php
require_once("cmRest.php");
require_once("stock_price_report.class.php");
		
class CmRestHandler extends cmRest {

	function getAllPrice($user_id, $websites, $date_range) {	
		
		$user_id = $user_id;
		#$websitesR = json_decode($websites, true);
		#foreach($websitesR as $website){
			
			$filter = new ApiSdata($user_id, $websites, $date_range);
			$rawData_1 = $filter->getpricedata();
			$rawData['data_price'][$websites] = $rawData_1['data_price'];
			$rawData['dates'][$websites] = $rawData_1['dates'];
			
		#}
		
		if(empty($rawData)) {
			$statusCode = 404;
			$rawData = array('error' => 'No data found!');		
		} else {
			$statusCode = 200;
		}
		$response = $this->encodeJson($rawData);
		echo $response; 
	}
	
	
	function getAllStock($user_id, $websites, $date_range) {	
		$user_id = $user_id;
		$website = $website;
		
		#$websitesR = json_decode($websites, true);
		#foreach($websitesR as $website){
			$filter = new ApiSdata($user_id, $websites, $date_range);
			$rawData_1 = $filter->getstockdata();
			$rawData['data_stock'][$websites] = $rawData_1['data_stock'];
			$rawData['dates'][$websites] = $rawData_1['dates'];
		#}
		if(empty($rawData)) {
			$statusCode = 404;
			$rawData = array('error' => 'No data found!');		
		} else {
			$statusCode = 200;
		}
		$response = $this->encodeJson($rawData);
		echo $response; 
		
	}
	
	
	function get_data_one_feild($user_id, $websites, $date_range, $data_feild) {	
		$user_id = $user_id;
		$website = $website;
		
		$websitesR = json_decode($websites, true);
		#foreach($websitesR as $website){
			$filter = new ApiSdata($user_id, 4, $date_range, $data_feild);
			$rawData_1 = $filter->get_one_feild_data($websitesR);
			$rawData['data'] = $rawData_1['data'];
			$rawData['dates'] = array_unique($rawData_1['dates']);
		#}
		if(empty($rawData)) {
			$statusCode = 404;
			$rawData = array('error' => 'No data found!');		
		} else {
			$statusCode = 200;
		}
		$response = $this->encodeJson($rawData);
		echo $response; 
		
	}
	
	function get_amazon_bsr_data($user_id, $websites, $date_range, $data_feild) {	
		$user_id = $user_id;
		$website = $website;
		
		$websitesR = json_decode($websites, true);
		
		#foreach($websitesR as $website){
			$filter = new ApiSdata($user_id, 4, $date_range, $data_feild);
			$rawData_1 = $filter->get_bsr_feild_data($websitesR);
			$rawData['data'] = $rawData_1['data'];
			$rawData['dates'] = array_unique($rawData_1['dates']);
		#}
		if(empty($rawData)) {
			$statusCode = 404;
			$rawData = array('error' => 'No data found!');		
		} else {
			$statusCode = 200;
		}
		$response = $this->encodeJson($rawData);
		echo $response; 
		
	}
	
	
	function get_seller_data($user_id, $websites, $date_range, $data_feild) {	
		$user_id = $user_id;
		$website = $website;
		
		$websitesR = json_decode($websites, true);
		#foreach($websitesR as $website){
			$filter = new ApiSdata($user_id, 4, $date_range, $data_feild);
			$rawData_1 = $filter->get_seller_data($websitesR);
			$rawData['data'] = $rawData_1['data'];
			$rawData['dates'] = array_unique($rawData_1['dates']);
		#}
		if(empty($rawData)) {
			$statusCode = 404;
			$rawData = array('error' => 'No data found!');		
		} else {
			$statusCode = 200;
		}
		$response = $this->encodeJson($rawData);
		echo $response; 
		
	}
	
	function get_all_data_single_feild($user_id, $websites, $data_feild, $product_sku, $account_sku) {	
		$user_id = $user_id;
		$website = $website;
		$date_range = null;
		$websitesR = json_decode($websites, true);
		foreach($websitesR as $website){
			$filter = new ApiSdata($user_id, $website, $date_range, $data_feild);
			$rawData_1 = $filter->get_one_feild_data_without_range($website, $product_sku, $account_sku);
			$rawData['data'] = $rawData_1['data'];
			$rawData['dates'] = array_unique($rawData_1['dates']);
		}
		
		if(empty($rawData)) {
			$statusCode = 404;
			$rawData = array('error' => 'No data found!');		
		} else {
			$statusCode = 200;
		}
		$response = $this->encodeJson($rawData);
		echo $response; 
		
	}
	
	
	function GetContentHistory($user_id, $websites, $data_range, $admin_qc = null) {	
		$user_id = $user_id;
		$website = $websites;
		
		$filter = new ApiSdata($user_id, $websites, null, null, $admin_qc);
		$rawData = $filter->get_website_content_history($website, $data_range);
		$rawData['data'] = $rawData['data'];
		
		if(empty($rawData)) {
			$statusCode = 404;
			$rawData = array('error' => 'No data found!');		
		} else {
			$statusCode = 200;
		}
		$response = $this->encodeJson($rawData);
		
		echo $response; 
	}
	
	
	function get_seller_price_margin_data($user_id, $website, $tab_name, $filters) {	
		
		$filter = new ApiSdata($user_id, $website, null, null, $admin_qc);
		
		#print $api_name; die;
		
		$rawData = $filter->get_seller_price_margin_data_tabs($website, $tab_name, $filters);
		$rawData['data'] = $rawData;
		
		if(empty($rawData)) {
			$statusCode = 404;
			$rawData = array('error' => 'No data found!');		
		} else {
			$statusCode = 200;
		}
		$response = $this->encodeJson($rawData);
		
		echo $response; 
	}
	
	function get_seller_price_graph($user_id, $website, $tab_name, $product_sku, $website_sku, $seller) {	
		
		$filter = new ApiSdata($user_id, $website, null, null, $admin_qc);
		
		#print $api_name; die;
		
		$rawData = $filter->get_seller_price_graph_data($website, $tab_name, $product_sku, $website_sku, $seller);
		$rawData['data'] = $rawData;
		
		if(empty($rawData)) {
			$statusCode = 404;
			$rawData = array('error' => 'No data found!');		
		} else {
			$statusCode = 200;
		}
		$response = $this->encodeJson($rawData);
		
		echo $response; 
	}
	
	
	
	
	function original_date_found($user_id, $websites) {	
		$user_id = $user_id;
		$website = $websites;
		
		$filter = new ApiSdata($user_id, $websites, null, null);
		$rawData = $filter->get_original_date_found($website);
		$rawData['data'] = $rawData['data'];
		
		if(empty($rawData)) {
			$statusCode = 404;
			$rawData = array('error' => 'No data found!');		
		} else {
			$statusCode = 200;
		}
		$response = $this->encodeJson($rawData);
		
		echo $response; 
	}
	
	public function encodeHtml($responseData) {
	
		$htmlResponse = "<table border='1'>";
		foreach($responseData as $key=>$value) {
    			$htmlResponse .= "<tr><td>". $key. "</td><td>". $value. "</td></tr>";
		}
		$htmlResponse .= "</table>";
		return $htmlResponse;		
	}
	
	public function encodeJson($responseData) {
		$jsonResponse = json_encode($responseData, JSON_INVALID_UTF8_IGNORE);
		return $jsonResponse;		
	}
	
	public function encodeXml($responseData) {
		// creating object of SimpleXMLElement
		$xml = new SimpleXMLElement('<?xml version="1.0"?><mobile></mobile>');
		foreach($responseData as $key=>$value) {
			$xml->addChild($key, $value);
		}
		return $xml->asXML();
	}
}
?>