<?php
include("header.php");

// Include the database connection file
$mysqli = include("db.php");

if (!$mysqli) {
    die('Failed to connect to the database.');
}

// Initialize arrays
$userArray = array();
$userNewArr = array();
$scheduleArr = array();
$productArray = array();

// Fetch user credentials
$query = "SELECT * FROM users ORDER BY username ASC";
if ($result = $mysqli->query($query)) {
    while ($row = $result->fetch_assoc()) {
        $user_name = $row['username'];
        $pass = $row['test_password'];
        $userArray[$user_name] = trim($pass);
    }
    $result->free();
} else {
    die('Error executing query: ' . $mysqli->error);
}



// Fetch users excluding disabled ones
$query = "SELECT id, username FROM users WHERE disabled != '1' ORDER BY username ASC";
if ($result = $mysqli->query($query)) {
    while ($row = $result->fetch_assoc()) {
        $user_id = $row['id'];
        $user_name = $row['username'];
        $user_pass = isset($userArray[$user_name]) ? $userArray[$user_name] : '';
        $userNewArr[$user_id][$user_name] = $user_pass;
    }
    $result->free();
} else {
    die('Error executing query: ' . $mysqli->error);
}

// Fetch schedule details
$query = "SELECT * FROM crawler_instances GROUP BY user_id";
if ($result = $mysqli->query($query)) {
    while ($row = $result->fetch_assoc()) {
        $user_id = $row['user_id'];
        $server_id = $row['server_id'];

        switch ($server_id) {
            case 1:
                $serverName = 'Master';
                break;
            case 2:
                $serverName = 'Node-2';
                break;
            case 3:
                $serverName = 'Node-3';
                break;
            case 5:
                $serverName = 'Cloud';
                break;
            default:
                $serverName = 'Unknown';
        }
		//print "$user_id===$server_id\n";
        // Fetch schedule for user
        $stmt = $mysqli->prepare("SELECT * FROM schedules WHERE user_id = ? GROUP BY user_id");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $res_s = $stmt->get_result();
        
        if ($res_s->num_rows > 0) {
            $row_s = $res_s->fetch_assoc();
            $row_s['server'] = $serverName;
            $scheduleArr[$user_id] = $row_s;
        }
        $stmt->close();
    }
    $result->free();
} else {
    die('Error executing query: ' . $mysqli->error);
}

// Fetch product counts
$query = "SELECT user_id, COUNT(*) as total FROM products GROUP BY user_id";
if ($result = $mysqli->query($query)) {
    while ($row = $result->fetch_assoc()) {
        $user_id = $row['user_id'];
        $total = $row['total'];
        $productArray[$user_id] = $total;
    }
    $result->free();
} else {
    die('Error executing query: ' . $mysqli->error);
}

//print_r($productArray);
// Close connection
$mysqli->close();

// Output HTML
?>
<table border=2>
    <tr>
        <td style="font-weight:bold;width:80px;color:#000000;background-color:#e8e8e8;margin:2px;padding:2px;font-size: 120%;" align="center">Sr. No.</td>
        <td style="font-weight:bold;width:55px;color:#000000;background-color:#e8e8e8;margin:2px;padding:2px;font-size: 120%;" align="center">ID</td>
        <td style="font-weight:bold;width:200px;color:#000000;background-color:#e8e8e8;margin:2px;padding:2px;font-size: 120%;" align="center">Name</td>
        <td style="font-weight:bold;width:80px;color:#000000;background-color:#e8e8e8;margin:2px;padding:2px;font-size: 120%;" align="center">Products</td>
        <td style="font-weight:bold;width:150px;color:#000000;background-color:#e8e8e8;margin:2px;padding:2px;font-size: 120%;" align="center">Run Date</td>
        <td style="font-weight:bold;width:151px;color:#000000;background-color:#e8e8e8;margin:2px;padding:2px;font-size: 120%;" align="center">Start Date</td>
        <td style="font-weight:bold;width:151px;color:#000000;background-color:#e8e8e8;margin:2px;padding:2px;font-size: 120%;" align="center">Frequency</td>
        <td style="font-weight:bold;width:151px;color:#000000;background-color:#e8e8e8;margin:2px;padding:2px;font-size: 120%;" align="center">Current Server</td>
    </tr>
</table>
<table border=2>
    <?php
    $sr_no = 0;
    foreach ($userNewArr as $user_id => $credential) {
        $rundate = $start_date = $server = null;
        if (array_key_exists($user_id, $scheduleArr)) {
            $rundate = date("d-M-Y", strtotime($scheduleArr[$user_id]['rundate']));
            $start_date = date("d-M-Y", strtotime($scheduleArr[$user_id]['start_date']));
            $frequency = $scheduleArr[$user_id]['frequency'];

            // Frequency Mapping
            $frequencyMap = [
                1 => '7 Days', 2 => '14 Days', 3 => '21 Days', 4 => '28 Days',
                5 => '5 Days', 6 => '6 Days', 7 => '7 Days', -1 => '1 Day',
                -2 => '2 Days', -3 => '3 Days', -4 => '4 Days'
            ];
            $frequency = $frequencyMap[$frequency] ?? 'Unknown';
            $server = $scheduleArr[$user_id]['server'];
        }
        foreach ($credential as $key => $value) {
            $sr_no++;
            ?>
            <tr>
                <td style="font-weight:bold;width:81px;color:#000000;background-color:#e8e8e8;margin:2px;padding:2px;" align="center"><?= $sr_no ?></td>
                <td>
                    <form action="https://www.mschannellogin.com/users/login/" method="POST" target="top">
                        <input name="data[User][username]" type="hidden" value="<?= htmlspecialchars($key) ?>" />
                        <input name="data[User][password]" type="hidden" value="<?= htmlspecialchars($value) ?>" />
                        <input style="font-weight:bold;width:50px;color:#000000;background-color:#e8e8e8;margin:2px;padding:2px;" value="<?= htmlspecialchars($user_id) ?>" />
                        <input style="font-weight:bold;width:190px;color:#000000;background-color:#e8e8e8;margin:2px;padding:2px;" type="submit" value="<?= htmlspecialchars(ucfirst($key)) ?>" />
                    </form>
                </td>
                <td style="font-weight:bold;width:81px;color:#000000;background-color:#e8e8e8;margin:2px;padding:2px;" align="center"><?= $productArray[$user_id] ?? '0' ?></td>
                <td style="font-weight:bold;width:151px;color:#000000;background-color:#e8e8e8;margin:2px;padding:2px;" align="center"><?= $rundate ?></td>
                <td style="font-weight:bold;width:151px;color:#000000;background-color:#e8e8e8;margin:2px;padding:2px;" align="center"><?= $start_date ?></td>
                <td style="font-weight:bold;width:151px;color:#000000;background-color:#e8e8e8;margin:2px;padding:2px;" align="center"><?= $frequency ?></td>
                <td style="font-weight:bold;width:151px;color:#000000;background-color:#e8e8e8;margin:2px;padding:2px;" align="center"><?= htmlspecialchars($server) ?></td>
            </tr>
            <?php
        }
    }
    ?>
</table>
