<?php
session_start(); 

// Check if the user is logged in; if not, redirect to index.php
if (!isset($_SESSION['is_login'])) {
    header("Location: index.php");
    exit(); // Ensure no further code is executed after redirect
}

// Include the database connection file
include "db.php";
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - MySamm</title>
    <meta name="author" content="Codrops">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css">

    <!-- Custom CSS -->
    <link rel="stylesheet" type="text/css" href="css/style.css">

    <!-- Favicon -->
    <link rel="icon" href="images/mysamm3.png" type="image/png">

    <!-- jQuery -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>

    <style>
        th {
            background-color: #000;
            color: #fff;
            padding: 10px;
        }
        /* Add other custom styles if needed */
    </style>

    <script>
        $(document).ready(function(){
            // Login button click event
            $("#login").click(function(){
                $("#load").show();
                $.ajax({
                    url: "ajax.php?q=login",
                    success: function(result) {
                        $("#load").hide();
                        $("#html").html(result);
                    }
                });
            });

            // RP button click event
            $("#rp").click(function(){
                $("#load").show();
                $.ajax({
                    url: "ajax.php?q=rp",
                    success: function(result) {
                        $("#load").hide();
                        $("#html").html(result);
                    }
                });
            });

            // EL button click event
            $("#el").click(function(){
                $("#load").show();
                $.ajax({
                    url: "ajax.php?q=el",
                    success: function(result) {
                        $("#load").hide();
                        $("#html").html(result);
                    }
                });
            });
        });
    </script>
</head>
<body>
    <div id="wrapper">
        <div class="header">
            <div class="header_content">
                Mysamm Super Admin | <a href="logout.php">Logout</a>
                <span>Server Time: <?php echo htmlspecialchars(shell_exec("date")); ?></span>
            </div>
        </div>

        <div class="example">
            <ul id="nav">
                <li><a href="panel_optimized.php">Panel</a></li>
                <li><a href="login.php" target="_blank">Login</a></li>
                <li><a href="#">All Status</a>
                    <ul>
                        <li><a href="system_status.php" target="_blank">System Status</a></li>
                        <li><a href="html_checker.php" target="_blank">Comprehensive Html Status</a></li>
                        <li><a href="daily_html_checker.php" target="_blank">Daily Html Status</a></li>
                        <li><a href="#">Comprehensive Screenshots Status</a>
                            <ul>
                                <li><a href="master_screenshots.php" target="_blank">Master</a></li>
                                <li><a href="all_screenshots.php" target="_blank">Others</a></li>
                            </ul>
                        </li>
                        <li><a href="daily_images.php" target="_blank">Daily Screenshots Status</a></li>
                    </ul>
                </li>
                <li><a href="#">UPDATE</a>
                    <ul>
                        <li><a href="price_update.php" target="_blank">Update Price</a></li>
                        <li><a href="proxy_updater.php" target="_blank">Update Proxies</a></li>
                        <li><a href="images_updater.php" target="_blank">Update Images</a></li>
                    </ul>
                </li>
                <li><a href="#">CHECKER</a>
                    <ul>
                        <li><a href="get_response.php" target="_blank">Get Response</a></li>
                        <li><a href="json_decode_encode.php" target="_blank">JSON Encode/Decode</a></li>
                        <li><a href="url_encode_decode.php" target="_blank">URL Encode/Decode</a></li>
                        <li><a href="url_redirect.php" target="_blank">Get Redirected URL</a></li>
                        <li><a href="code_checker.php" target="_blank">Code Checker</a></li>
                    </ul>
                </li>
                <li><a href="http://208.43.61.98/~mantis/view_all_bug_page.php?" target="_blank">MANTIS</a></li>
                <li><a href="#">DATABASES</a>
                    <ul>
                        <li><a href="http://192.163.194.176:2082/cpsess2265029364/3rdparty/phpMyAdmin/index.php" target="_blank">Master</a></li>
                        <li><a href="https://162.144.98.23:2083/cpsess3649141472/3rdparty/phpMyAdmin/index.php" target="_blank">Node-2</a></li>
                        <li><a href="https://198.57.221.92:2083/cpsess9765143806/3rdparty/phpMyAdmin/index.php" target="_blank">Node-3</a></li>
                        <li><a href="https://162.144.87.218:2083/cpsess605289831/3rdparty/phpMyAdmin/index.php" target="_blank">User-Interface</a></li>
                    </ul>
                </li>
                <li><a href="http://162.144.98.23/~mysamm/admin/panel.php" target="_blank">Node-2 UI</a></li>
                <li><a href="download_crawled_report.php" target="_blank">Download Crawled Report</a></li>
            </ul>
        </div>
    </div>
</body>
</html>
